﻿//////////////////////////////////////////////
// Resource.h
//
// Base pour toute ressource :
// Shader, Mesh, Texture...
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class System ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "Enums/ResourceLoadState.h"
#include "Enums/ResourceType.h"

// nkMemory
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>
	
/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT Resource
	{		
		public :
		
			// Destructor
			virtual ~Resource () ;

			// Getters
			bool isReadyForRendering () const ;
			bool isUnloaded () const ;
			RESOURCE_LOAD_STATE getLoadState () const ;
			nkMemory::StringView getPath () const ;
			RESOURCE_TYPE getTypeName () const ;
			nkMemory::StringView getName () const ;
			System* getSystem () const ;
			bool getHidden () const ;
			bool getGpuUploadCanBeDeferred () const ;

			// Setters
			virtual void setPath (nkMemory::StringView value) ;
			void setName (nkMemory::StringView value) ;
			void setHidden (bool value) ;
			void setGpuUploadCanBeDeferred (bool value) ;

			// Loading
			virtual bool load () = 0 ;
			virtual void unload () = 0 ;

		protected :

			// Functions
			// Constructor
			Resource (System* system) noexcept ;

		protected :
		
			// Attributs
			// Loading state
			RESOURCE_LOAD_STATE _loadState ;
			// An identifier to know what kind of resource it is
			RESOURCE_TYPE _typeName ;

			// System it lives in
			System* _system ;

			// Its path and name to identify it
			nkMemory::String _path ;
			nkMemory::String _name ;

			// Whether it will be hidden during a global export
			bool _hidden ;
			// Whether the resource's loading can be deferred or not before rendering
			bool _gpuUploadCanBeDeferred ;
	} ;
}